unit Pliki;

interface

uses Classes, SysUtils, Windows, ComCtrls, Graphics
{$IF DEFINED(CLR)}
,System.Text
{$IFEND}
;

procedure ZapiszDoPlikuTekstowego(nazwaPliku :String;linie :TStrings);
function CzytajZPlikuTekstowego(nazwaPliku :String) :TStrings;

type TPlikRejestrowania = class
  public
    constructor Create(nazwaPliku :String);
    procedure Dopisz(tekst :String);
  private
    nazwaPliku :String;
    uzytkownik :String;
  end;

procedure ZapelnijDrzewo(drzewo :TTreeView;wezel :TTreeNode;katalog :String; czyDodawacPliki,czyPosortowac :Boolean);

type ZapelnijDrzewoWatek = class(TThread)
 private
  drzewo :TTreeView;
  wezel :TTreeNode;
  katalog :String;
  czyDodawacPliki,
  czyPosortowac :Boolean;
 public
  constructor Create(drzewo :TTreeView;wezel :TTreeNode; katalog :String; czyDodawacPliki,czyPosortowac :Boolean);
  procedure Execute; override;
 end;

var ZapelnijDrzewoWatek_Zakonczony :Boolean = False;

implementation

procedure ZapiszDoPlikuTekstowego(nazwaPliku :String;linie :TStrings);
var
  plikWy :TextFile;
  i :Integer;
begin
AssignFile(plikWy,nazwaPliku);
Rewrite(plikWy);
for i:=0 to linie.Count-1 do WriteLn(plikWy,linie[i]);
CloseFile(plikWy);
end;

function CzytajZPlikuTekstowego(nazwaPliku :String) :TStrings;
var
  plikWe :TextFile;
  linia :String;
begin
Result:=TStringList.Create;
AssignFile(plikWe,nazwaPliku);
Reset(plikWe);
repeat
  ReadLn(plikWe,linia);
  Result.Add(linia);
  until Eof(plikWe);
CloseFile(plikWe);
end;

constructor TPlikRejestrowania.Create(nazwaPliku :String);
var
  {$IF NOT DEFINED(CLR)}
  uzytkownik :array[0..255] of Char; //Win32
  {$ELSE}
  uzytkownik :StringBuilder; //.NET, wymaga modulu System.Text;
  {$IFEND}
  rozmiarUzytkownik :Cardinal;
begin
inherited Create;

Self.nazwaPliku:=nazwaPliku;

{$IF NOT DEFINED(CLR)}
rozmiarUzytkownik:=SizeOf(uzytkownik);
GetUserName(uzytkownik,rozmiarUzytkownik);
Self.uzytkownik:=String(uzytkownik);
{$ELSE}
rozmiarUzytkownik:=256;
uzytkownik:=StringBuilder.Create(rozmiarUzytkownik);
GetUserName(uzytkownik,rozmiarUzytkownik);
Self.uzytkownik:=uzytkownik.ToString;
{$IFEND}
end;

procedure TPlikRejestrowania.Dopisz(tekst :String);
var
  plikWy :TextFile;
  czasZapisu :String;
begin
czasZapisu:=DateTimeToStr(Now);
AssignFile(plikWy,nazwaPliku);
if FileExists(nazwaPliku) then Append(plikWy)
                          else Rewrite(plikWy);
WriteLn(plikWy,czasZapisu+'  '+tekst+' (uzytkownik: '+uzytkownik+')');
Close(plikWy);
end;

procedure ZapelnijDrzewo(drzewo :TTreeView;wezel :TTreeNode; katalog :String; czyDodawacPliki,czyPosortowac :Boolean);
var
  sr :TSearchRec;
  wynik,dlg :Integer;
  dopisz,dopiszKatalog :Bool;
  nowyWezel :TTreeNode;
begin
dlg:=Length(katalog);
if katalog[dlg]='\' then SetLength(katalog,dlg-1);
wynik:=FindFirst(katalog+'\*.*', faAnyFile, sr);

if wezel=nil then
  begin
  //drzewo.Items.Clear;
  wezel:=drzewo.Items.AddNode(nil,nil,ExtractFileName(katalog),nil,naAddChild); //sr.Name='.'
  end;

while wynik=0 do
  begin
  dopisz:=True;
  dopiszKatalog:=False;
  if (sr.Attr and faDirectory)=faDirectory then dopiszKatalog:=True;
  if (sr.Name='.') or (sr.Name='..') then dopisz:=False;
  if dopisz then
    if dopiszKatalog then
                     begin
                     nowyWezel:=drzewo.Items.AddNode(nil,wezel,sr.Name,nil,naAddChild);
                     ZapelnijDrzewo(drzewo,nowyWezel,katalog+'\'+sr.Name,czyDodawacPliki,czyPosortowac);
                     end
                     else
                     if czyDodawacPliki then drzewo.Items.AddChild(wezel,sr.Name);
  wynik:=FindNext(sr);
  end;

SysUtils.FindClose(sr);
if czyPosortowac then wezel.AlphaSort(False);
end;

//wersja Win32
{constructor ZapelnijDrzewoWatek.Create(drzewo :TTreeView;wezel :TTreeNode; katalog :String; czyDodawacPliki,czyPosortowac :Boolean);
begin
Self.drzewo:=drzewo;
Self.wezel:=wezel;
Self.katalog:=katalog;
Self.czyDodawacPliki:=czyDodawacPliki;
Self.czyPosortowac:=czyPosortowac;
FreeOnTerminate:=True;
inherited Create(False); //automatyczne uruchomienie watku
ZapelnijDrzewoWatek_Zakonczony:=False;
end;}

//wersja zgodna w Win32 i .NET
constructor ZapelnijDrzewoWatek.Create(drzewo :TTreeView;wezel :TTreeNode; katalog :String; czyDodawacPliki,czyPosortowac :Boolean);
begin
inherited Create(True); //stworzenie watku, ale bez uruchomienia
Self.drzewo:=drzewo;
Self.wezel:=wezel;
Self.katalog:=katalog;
Self.czyDodawacPliki:=czyDodawacPliki;
Self.czyPosortowac:=czyPosortowac;
FreeOnTerminate:=True;
Resume; //uruchomienie watku
ZapelnijDrzewoWatek_Zakonczony:=False;
end;

procedure ZapelnijDrzewoWatek.Execute;
begin
drzewo.Color:=clBtnHighlight;
ZapelnijDrzewo(drzewo,wezel,katalog,czyDodawacPliki,czyPosortowac);
ZapelnijDrzewoWatek_Zakonczony:=True;
drzewo.Color:=clWindow;
end;

end.
